%	Rev. by Fang Jin on 2009-02-03: load vessel data from file to A 
	% A{1}=nodes;
	% A{2}=branches;
	% A{3}=loops;
	% A{4}=root_list;
	% A{5}=lead_list;	

function A=cappost(frame,op)

		function b=inopt(s)
			tmp = findstr(s,op);
			b = ~isempty(tmp);
		end

	  function v=read_int_vector(fid)
	    v=[];
	    sz = fscanf(fid,'%d',1);
	    if (sz<1), return; end
	    v = fscanf(fid,'%d',sz)';
	  end

	  function [n,nlist]=read_nodes(fid)
	    n = [];
			nlist =[];
	    sz = fscanf(fid,'%d',1);
	    if (sz<1), return; end
			ni = 0;
	    for i=1:sz
	      vec_index = fscanf(fid,'%d',1);
	      vec_empty = fscanf(fid,'%s',1);
	      if (vec_empty == 'T'),
	        node_id = fscanf(fid,'%d',1);
					node_enabled = fscanf(fid,'%s',1);
	        node_pos = fscanf(fid,'%f',3);
	        node_branches = read_int_vector(fid);
	        n{node_id,1} = node_pos';
	        n{node_id,2} = node_branches;
					n{node_id,3} = (node_enabled == 'T');
					ni=ni+1;
					nlist(ni) = i;
	      end
	    end
	  end

	  function [b,blist]=read_branches(fid)
	    b = [];
		blist = [];
	    sz = fscanf(fid,'%d',1);
	    if (sz<1), return; end
		bi = 0;
	    for i=1:sz
	      vec_index = fscanf(fid,'%d',1);
	      vec_empty = fscanf(fid,'%s',1);
	      if (vec_empty == 'T'),
	        branch_id = fscanf(fid,'%d',1);
	        root_id = fscanf(fid,'%d',1);
		    branch_enabled = fscanf(fid,'%s',1);
		    branch_dob = fscanf(fid,'%f',1);
		    branch_flow = fscanf(fid,'%f',1);
	        branch_nodes = read_int_vector(fid);
	        branch_loops = read_int_vector(fid);
	        b{branch_id,1} = root_id;
	        b{branch_id,2} = branch_nodes;
	        b{branch_id,3} = branch_loops;
		    b{branch_id,4} = (branch_enabled =='T');
		    b{branch_id,5} =  branch_dob;
		    b{branch_id,6} =  branch_flow;
		    bi=bi+1;
		    blist(bi)=i;
	      end
	    end
      end

        function [l,llist]=read_loops(fid)
            l = [];
			llist = [];
            sz = fscanf(fid,'%d',1);
            if (sz<1), return; end
			li = 0;
            for i=1:sz
                vec_index = fscanf(fid,'%d',1);
                vec_empty = fscanf(fid,'%s',1);
                if (vec_empty == 'T'),
					loop_id = fscanf(fid,'%d',1);
					loop_enabled = fscanf(fid, '%s', 1);
					loop_dob = fscanf(fid,'%f',1);
					loop_branches = read_int_vector(fid);
					l{loop_id,1} = loop_branches;
					l{loop_id,2} = (loop_enabled =='T');
					l{loop_id,3} = loop_dob;
					li=li+1;
					llist(li)=i;
                end
            end
        end
	  
		function load_vessels(nn)
            s1 = ['0000000' num2str(nn)];
            s2 = s1((length(s1)-4):length(s1));
            IN  = ['v' s2 '.dat'];
            IN2 = [IN '.gz'];
            IN2EXIST=exist(IN2,'file');
            if (IN2EXIST),
                system(['gunzip ' IN2]);
            end
			f = fopen(IN,'r');
			[nodes,node_list] = read_nodes(f);
			[branches,branch_list] = read_branches(f);
			[loops,loop_list] = read_loops(f);
			fclose(f);
      if (IN2EXIST),
        system(['gzip ' IN]);
      end
        end
        
        function [bl]=branch_length(bindex)
            nlist=branches{bindex,2};
			nc = length(nlist);
            bl=0.0;
            if (nc<2), return; end;
            p1=nodes{nlist(1),1};
    	  	for k=2:nc,
                p2=nodes{nlist(k),1};
                bl=bl+sqrt(sum((p2-p1).^2));
                p1=p2;
    	  	end
        end
		
		function category_vessels
			root_list =[];
			lead_list =[];
			disabled_list =[];
            looped_branch_list = [];
            tvl=0.0;
            lvl=0.0;
            
			sz = length(branch_list);
			if (sz<1), return; end;
			ri=0;
			li=0;
			di=0;
            lbi=0;
            
			for i=1:sz
				branch_id = branch_list(i);
				% disabled branch
				if (~branches{branch_id,4}),
					di = di+1;
					disabled_list(di) = branch_id;
                    continue;
                end
                vessel_length = branch_length(branch_id);
                tvl = tvl + vessel_length;
				% root branch
				root_id = branches{branch_id,1};
				if (isempty(find(root_list==root_id)))
					ri = ri+1;
					root_list(ri) = branch_id;
				end
				% lead branch
				node_id = branches{branch_id,2}(end);
				if (length(nodes{node_id,2}) == 1),
					li = li+1;
					lead_list(li) = branch_id;
                end
                % loop branch
				if (inopt('g')),
				    if (branches{branch_id,6}>0),
                        lbi = lbi +1;
                        looped_branch_list(lbi) = branch_id;
                        lvl = lvl + vessel_length;
					end
				else
                    if ~(isempty(branches{branch_id,3})),
                        lbi = lbi +1;
                        looped_branch_list(lbi) = branch_id;
                        lvl = lvl + vessel_length;
					end
			    end
                
			end
			
		end
		
	load_vessels(frame)
	category_vessels
	A{1}=nodes;
	A{2}=branches;
	A{3}=loops;
	A{4}=root_list;
	A{5}=lead_list;	
	A{6}=disabled_list;
	A{7}=node_list;				% valid list
	A{8}=branch_list;
	A{9}=loop_list;
	A{10}=looped_branch_list;
    A{11}=[length(A{8}) length(A{10}) length(A{4}) tvl lvl];
		
end
