function[] = fjisosurfm(varargin)
	
    function drawbox(g1,g2,g3,lvl)
        cl={'black','blue','red','green','cyan','magenta'};
        lw=[2 2 1 1 0.5 0.5];
        % fix z
        x=[g1(1) g1(end) g1(end) g1(1)   g1(1)];
        y=[g2(1) g2(1)   g2(end) g2(end) g2(1)];
        z=[g3(1) g3(1)   g3(1)   g3(1)   g3(1)];
        line(x,y,z,'Color',cl{lvl},'LineWidth',lw(lvl));
        x=[g1(1)   g1(end) g1(end) g1(1)   g1(1)];
        y=[g2(1)   g2(1)   g2(end) g2(end) g2(1)];
        z=[g3(end) g3(end) g3(end) g3(end) g3(end)];
        line(x,y,z,'Color',cl{lvl},'LineWidth',lw(lvl));
        % fix x
        x=[g1(1) g1(1)   g1(1)   g1(1)   g1(1)];
        y=[g2(1) g2(end) g2(end) g2(1)   g2(1)];
        z=[g3(1) g3(1)   g3(end) g3(end) g3(1)];
        line(x,y,z,'Color',cl{lvl},'LineWidth',lw(lvl));
        x=[g1(end) g1(end) g1(end) g1(end) g1(end)];
        y=[g2(1)   g2(end) g2(end) g2(1)   g2(1)];
        z=[g3(1)   g3(1)   g3(end) g3(end) g3(1)];
        line(x,y,z,'Color',cl{lvl},'LineWidth',lw(lvl));
    end
	
    if nargin~=4, 
      disp('Three dimension data viewer, supports 3D contour and 4D surface property view');
      disp('  usage: INPUT');
      disp('  usage: 1) tumor object data format');
      disp('  usage: 	ex. for isosurface plot, use {fd3{1},0.5,"r",0.8}');
      disp('  usage: 	    to specify data, iso value, color and transparent');
      disp('  usage: 	ex. for 4D property plot, use {fd3{1},0.5,fd3{5},0.8}');
      disp('  usage: 	    to specify data, iso value, color data and transparent');
      disp('  usage: 2) bounding vector, including axis range and value range');
      disp('  usage:    ex. [] for automatic x,y and z');
      disp('  usage:    ex. [0 1 0 1 0 1] for x->[0,1], y->[0,1], z->[0,1]');
      disp('  usage:    ex. [0 1 0 1 0 1 0 2] for x->[0,1], y->[0,1], z->[0 1] and v->[0,2]');
      disp('  usage: 3) view angle vector, [45 45]');
      disp('  usage: 4) option string, support flag');
      disp('  usage:    letter o: plot on new figure instead of previous one')
      disp('  usage:    letter s: scale the graph with x to y ratio 1:1')
      disp('  usage:    letter c: use simple color scheme instead of standard hsv')
      disp('  usage:    letter b: show all patches box boundary')
      disp('  usage:    letter g: not supported currently')
      disp('  usage:    letter f: 4D plot, autosupport, dont need to set')
      disp('  usage:    letter a: turn off all axis and colorbar')
      disp('  usage:    letter r: turn on rotation helper, only works for 3D')
      disp('  usage: OUTPUT');
      return
    end


	fd3=varargin{1};        % data cells
	                        % matrix, iso, color, alpha
	ax=varargin{2};         % axes limit vector
	va=varargin{3};         % view angle
	op=varargin{4};         % options 'gs' 
	
	% check 4D automatically
	if iscell(fd3{1,3}),
		if ~inopt('f',op), op=[op 'f']; end;
	end

	if inopt('o',op), figure; end;
	for j=1:size(fd3,1),
	    mc=fd3{j,1};
	    mcn=size(mc,1);           % how many matrixes need to plot
	    mlv=mc{mcn,3};            % max level available
	    val=fd3{j,2};
	    col=fd3{j,3};
	    alp=fd3{j,4};
	    for i=1:mcn
	        % figure out plot range
	        if mc{i,3}~=mlv, continue; end;
	        V=mc{i,1};
	        sp=mc{i,2};
	        hold on;
	        [X,Y,Z]=meshgrid(sp{1,1},sp{2,1},sp{3,1});        
	        p=patch(isosurface(X, Y, Z, V, val));
	        isonormals(X,Y,Z,V,p);
			if inopt('f',op), 
        		CV=col{i,1};
        		isocolors(X,Y,Z,CV,p);
        		set(p,'FaceColor','interp');
			else
	        	set(p, 'FaceColor', col);
			end
	        set(p, 'EdgeColor', 'none', 'FaceAlpha', alp);
	
	        if inopt('b',op), drawbox(sp{1,1},sp{2,1},sp{3,1},mc{i,3}+1); end;
	    end
	end
	daspect([1 1 1]);

	if ~isempty(ax), axis(ax); end;
	if inopt('s',op), axis equal, end
	if ~isempty(ax), axis(ax); end;
	xlabel('x'), ylabel('y'); zlabel('z');

	if length(ax)<7, 
	  caxis auto; 
	else
	  caxis([ax(7) ax(8)]);
	end;

	view(va);
	material dull; 
	if inopt('f',op), 
		lighting phong;
	else
		camlight headlight;
		lighting gouraud
	end
	grid on
	
	if inopt('c',op), 
	  load('fjhotb','fjhot')
	  colormap(fjhot);
	end 
	if inopt('a',op),
		axis off
	else
		if inopt('f',op), colorbar; end;
	end
	
	if inopt('r',op),
		rotate3d
	end

end
