%	Rev. by Fang Jin on 2009-02-03: plot vessel based on A 

%	A - is the vessel data from cappost loading
% blist - is the list of data handles, could be branches and loops
%					if empty, stands for all of them
%	op - 	'l' for loops
%				'b' for branches
%				'v' for branches with same root
%				'x' include the disabled branch
%				'o' for re-plot to previous plot
%				'd' for debug mode, display branch list
%       'n' for ignoring all node except ends

% pop - {'r',4}

% use cappost3 or 4

% cinfo - {7,[-1 1]}, index of variable and range of the variable

function [binfo,linfo]=fjvesselplot(A,blist,domain,cinfo,va,op)

		function b=inopt(s)
			tmp = findstr(s,op);
			b = ~isempty(tmp);
    end

	  function plot_nodes(nlist,col,wid)
      if (wid<=0), wid=1; end;
				
      nc=length(nlist);
      nodes_pos = [];

	  	hold on
	  	nodes_pos = [];
      if (~inopt('s')),
    	  	for k=1:nc
            nodes_pos(k,1:3)=nodes{nlist(k),1};    		
    	  	end
    	  	% plot(nodes_pos(:,1),nodes_pos(:,2),['-' col]);		
    	  	plot3(nodes_pos(:,1),nodes_pos(:,2),nodes_pos(:,3),'Color',col, ...
                                      'LineWidth',wid);
      else
          nodes_pos(1,1:3)=nodes{nlist(1),1};		% first node of branch
          nodes_pos(2,1:3)=nodes{nlist(end),1};	% end node
    	  	plot3(nodes_pos(:,1),nodes_pos(:,2),nodes_pos(:,3),'-','Color',col, ...
                                      'LineWidth',wid);
      end
                                              

      % color the end nodes
      if (inopt('h')),
        pos(1:3)=nodes{nlist(1),1};		% first node of branch
        plot3(pos(1),pos(2),pos(3),'o', ...
                          'MarkerEdgeColor','r', ...
                          'MarkerFaceColor','r','MarkerSize',4);
                        
        if (inopt('d')),
          text(pos(1)+0.001,pos(2),pos(3),[num2str(nlist(1))], ...
              'Color','r','FontWeight','bold','FontSize',12);
        end
      end                  
        
			if (inopt('e')),
        pos(1:3)=nodes{nlist(end),1};	% end node
        % figure out the last nodes' branch number
        jc = length(nodes{nlist(end),2});
        dc = {'k';'g'};
        if (jc<3), 
          plot3(pos(1),pos(2),pos(3),'o', ...
                            'MarkerEdgeColor',dc{jc}, ...
                            'MarkerFaceColor',dc{jc},'MarkerSize',4);
        end
      end
      
			hold off
	  end  
  
  
	  function bi=plot_branch(bindex,col,wid)
			if (isempty(branches{bindex,1})), 
				disp({'branch id invalid' bindex});
			end;
      
      if (wid<=0), wid=1; end;
				
      nodes_pos = [];

      nlist=branches{bindex,2};
			nc = length(nlist);
      root=branches{bindex,1};
			enabled=branches{bindex,4};
			age=branches{bindex,5};
      	
      if (~enabled & ~inopt('x')), return; end;

	  	hold on
	  	nodes_pos = [];
      if (~inopt('n')),
    	  	for k=1:nc
            nodes_pos(k,1:3)=nodes{nlist(k),1};    		
    	  	end
    	  	% plot(nodes_pos(:,1),nodes_pos(:,2),['-' col]);		
    	  	plot3(nodes_pos(:,1),nodes_pos(:,2),nodes_pos(:,3),'Color',col, ...
                                      'LineWidth',wid);
      else
          nodes_pos(1,1:3)=nodes{nlist(1),1};		% first node of branch
          nodes_pos(2,1:3)=nodes{nlist(end),1};	% end node
    	  	plot3(nodes_pos(:,1),nodes_pos(:,2),nodes_pos(:,3),'-','Color',col, ...
                                      'LineWidth',wid);
      end
                                              

      % color the end nodes
      if (inopt('h')),
        if (root==bindex), % head node
          pos(1:3)=nodes{nlist(1),1};		% first node of branch
          plot3(pos(1),pos(2),pos(3),'o', ...
                            'MarkerEdgeColor','r', ...
                            'MarkerFaceColor','r','MarkerSize',4);
        end
        
        pos(1:3)=nodes{nlist(end),1};	% end node
        % figure out the last nodes' branch number
        jc = length(nodes{nlist(end),2});
        dc = {'k';'g'};
        if (jc<3), 
          plot3(pos(1),pos(2),pos(3),'o', ...
                            'MarkerEdgeColor',dc{jc}, ...
                            'MarkerFaceColor',dc{jc},'MarkerSize',4);
        end
      end
      
      % text version
      if (root==bindex), % head node
          pos(1:3)=nodes{nlist(1),1};		% first node of branch
          if (inopt('d')),
            text(pos(1)+0.001,pos(2),pos(3),[num2str(bindex)], ...
                    'Color','r','FontWeight','bold','FontSize',14);
          end
      else                % joint node
          mpos = int8(nc/2);
          pos(1:3)=nodes{nlist(mpos),1};	% end node
          if (inopt('d')),
            text(pos(1)+0.001,pos(2),pos(3),[num2str(bindex)], ...
                    'Color','b','FontWeight','bold','FontSize',14);
          end
      end
      
      
	
			hold off
			bi = [0.0 0.0 0.0];
			if (inopt('d')),
				blen = 0.0;
				for k=2:nc,
					lsqr = (nodes_pos(k,:)-nodes_pos(k-1,:)).^2;
					blen = blen + sqrt(sum(lsqr));
				end
				bi=[nc blen age];
				% disp(['branch ' num2str(bindex) ': N' ... 
				% 				num2str(nc) ' LPN ' num2str(blen/nc)])
				% binfo(bindex,1) = nc;
				% binfo(bindex,2) = blen;
				% binfo(bindex,3) = dob;
			end
	  end
	
		% plot branches with same root
		function plot_root(rindex)
			% come up with a list of branches id 
			j = 0;
			for i = 1:branches_size
				branch_id = branch_list(i);
	  		root=branches{branch_id,1};
				if (root==rindex), 
					j=j+1;
					blist(j)=i;
				end
			end
			plot_branch_list(blist);
		end

		% plot all the branch id in the list
		function plot_branch_list(list)
			if (length(list)<1), return; end;
	    for i=1:length(list)
				branch_id = list(i);
				root_id = branches{branch_id,1};
				% color = branch_color(color_list(root_id),:);
				aged = branches{branch_id,5}>12;
				if (inopt('g')),
          lps = branches{branch_id,3};
          lpd_old = ~isempty(lps);
          lpd_new = (branches{branch_id,6}~=0);
          if (~inopt('f')),   % old scheme of visualization
            lpd = int8(lpd_old);
          else                % new scheme of visualization
            lpd = int8(lpd_new);
            if inopt('y'),
              if (lpd_old ~= lpd_new),
                lpd = -(lpd+1);       % track the difference between
              end
            end
          end
          
          if (lpd<0),
            if (lpd<-1),
              color = [.53 0 .8];     % now unlooped
            else
              color = [1 .6 0];       % now looped
            end
          else
            if (lpd<1),
              color = [0.6 0.6 0.6];  % unlooped
            else
              color = [0 0 1];        % looped
            end
          end
        end
        rad = 2;
        if (inopt('r')), rad=12-branches{branch_id,8}*2; end;
				bif=plot_branch(branch_id,color,rad);
				binfo(i,:)=bif;
			end
		end
		
		% plot branch with color 
		function plot_branch_color_list(list)
			if (length(list)<1), return; end;
			ci = cinfo{1};
			crange = cinfo{2};
	    for i=1:length(list)
				branch_id = list(i);
				root_id = branches{branch_id,1};

        % figure out color of the branch
				co = branches{branch_id,ci};
        % co = 2.95e5*6e-9*exp(-6.63e-4*(1.0+1.07e4*0.0045)*co)
        % co = 2.95e5*6e-9*exp(-6.63e6*co)
        % if (co >0.001), co =0.0; end;
        ctmp=(co-crange(1))/(crange(2)-crange(1));
        if (ctmp<0),ctmp=0.0; end;
        if (ctmp>1.0), ctmp=1.0; end;
        ctmp2=round(ctmp*(length(fjvessel)-1))+1;
        color=fjvessel(ctmp2,:);
				
				bif=plot_branch(branch_id,color,2);
				binfo(i,:)=bif;
			end
		end		
	
		% plot all the loop id in the list
		function plot_loop_list(list)
			% if (inopt('d')),
			% 	disp('loop_list')
			% 	disp(list)
			% end
			for i=1:length(list)
				loop_id = list(i);
				enabled = loops{loop_id,2};
				age = loops{loop_id,3};
				if (~enabled & ~inopt('x')), continue; end;
				plot_branch_list(loops{loop_id});
				linfo(i,1) = age;
			end
    end
  
		% plot the navigatory node list
		function plot_nav_list(list)
			if (length(list)<1), return; end;
	    for i=1:length(list)
        color = [0.6 0.6 0.6];
				plot_nodes(list{i},color,2);
			end
		end
  
    %
		function plot_root_list(list)
			for i=1:length(list)
				root_id = root_list(list(i));
				plot_root(root_id);
			end
		end
		
		%
		function cl = make_roots_color(rlist)
			for i =1:length(rlist),
				root_id = branches{root_list(i),1};
				cl(root_id) = i;
			end
		end
						
		%
		function alc=count_aged_loops(list)
		  alc=0;
		  for i=1:loops_size,
				loop_id = list(i);
				if (loops{loop_id,3}>12), alc=alc+1; end;
	    end
	  end 
		
	%
	% MAIN ROUTINE
	%			
	% rename the input variable
	nodes=A{1};
	branches=A{2};
	loops=A{3};
	root_list=A{4};
	lead_list=A{5};
	nav_list=A{6};
	node_list=A{7};
	branch_list=A{8};
	loop_list=A{9};
	crushes_size=A{10};
	% name size
	nodes_size = length(node_list);
	branches_size = length(branch_list);
	loops_size = length(loop_list);
	roots_size = length(root_list);
	leads_size = length(lead_list);
	if (inopt('a')), aged_loops_size = count_aged_loops(loop_list); end;
	
	binfo =[];
	linfo =[];
		
  if (branches_size<1), return; end;
        
	% hsv colorcube flag lines prism
	color_list = make_roots_color(root_list);
	branch_color = lines(roots_size);
	if inopt('o'),
    mute = 'on';
    if inopt('m'), mute='off'; end;
    figure('Visible',mute);
	  hold on;
	end;
	%figure
	tstr =[' R',num2str(roots_size), ...
				 ' LE',num2str(leads_size), ...
				 ' N',num2str(nodes_size),' B',num2str(branches_size), ...
				 ' L',num2str(loops_size)];
%	if (crushes_size>0), tstr =[tstr,' CR',num2str(crushes_size)]; end;
%	if (inopt('a')), tstr = [tstr,' A',num2str(aged_loops_size)]; end;
	
	title(tstr);
	if (inopt('d')), disp(tstr); end;
  if (inopt('f')), load('fjvessel','fjvessel'); end;
	  
	% add plot features
	if inopt('b'),
		if (isempty(blist)),
		  if (~isempty(cinfo)), 
			  plot_branch_color_list(branch_list);
			else
			  plot_branch_list(branch_list);
		  end
		else
			plot_branch_list(blist);
		end
	end
	if inopt('l'),
		if (isempty(blist)),
			plot_loop_list(loop_list);
		else
			plot_loop_list(blist);
		end
  end
  if inopt('n'),
    plot_nav_list(nav_list);
  end
	if inopt('v'),
		if (isempty(blist)),
			plot_root_list(root_list);
		else
			plot_root_list(blist);
		end
	end
	% if inopt('d'),
	% 	plot_branch_list(disabled_list);
	% end
	
  if (inopt('f')), 
    colormap(fjvessel); 
    cbar_axes=colorbar('YTickLabel',{}); 
  end;
	grid on
	axis equal
  if ~isempty(va), view(va); end;
	if ~isempty(domain), axis(domain), end;
% 	rotate3d on
end
