% m00001.dat.gz is the adaptive mesh
% u00001.dat.gz is the uniform mesh

% load data.
% this tmmpost function only reads files starting with 'm'. So in order to
% load the uniform mesh, one has to rename u00001.dat.gz to m00001.dat.gz, 
% for instance, or modify this function.
% parameter is the frame number
[~,f] = tmmpost(1);

% prepare isosurface data.
% paramteres:
% field to plot, isosurface level, color, transparency
% total tumor: f{1}; dead cells: f{6}; stem cells: f{11}; committed progenitors: f{12}
fdd = {f{1}, 0.5, 'y', 0.5};

% plot isosurfaces
% parameters:
% prepared data, region, viewing angle, options
fjisosurfm(fdd, [15 25 15 25 15 25], [45 45], 'os');

% plot vessels
% first parameter is the frame number
A = cappostA(1,'');
fjvesselplotA(A, [], [15 25 15 25 15 25], {}, [45,45], 'behg');

% Fortran subroutines for outputs are in bsaminputoutput.f90.
% Adaptive mesh: see OutputQ
% Uniform mesh: see WriteUniformMeshQ
