% tumor post processing 

% try tmmpost; for help 

function [time,fd] = tmmpost(varargin) 

    function [mat2]=center_to_node(mat)
        sz=size(mat);
        mat2=zeros(sz-1,'double');
        if (length(sz)<3),
            ms=size(mat2);
            for ii=1:ms(1),
                for jj=1:ms(2),
                    mat2(ii,jj)=(mat(ii,  jj  ) + mat(ii+1,jj  )+ ...
                                 mat(ii+1,jj+1) + mat(ii  ,jj+1)  ...
                                )/4.0;
                end
            end
        else
            ms=size(mat2);
            for ii=1:ms(1),
                for jj=1:ms(2),
                    for kk=1:ms(3),
                        mat2(ii,jj,kk)=(mat(ii,  jj,  kk  ) + mat(ii+1,jj  ,kk  )+ ...
                                        mat(ii+1,jj+1,kk  ) + mat(ii  ,jj+1,kk  )+ ...
                                        mat(ii,  jj,  kk+1) + mat(ii+1,jj  ,kk+1)+ ...
                                        mat(ii+1,jj+1,kk+1) + mat(ii  ,jj+1,kk+1)  ...
                                       )/8.0;
                    end
                end
            end
        end
    end

    % error(nargchk(2, 2, nargin));
    time = -1.0;
    fd = [];
	op = '';

	nn=varargin{1};
	if (nargin>1), op=varargin{2}; end;

    if nargin<1, 
      disp('Tumor data post processing subroutine, supports 2D and 3D adaptive data');
      disp('  usage: INPUT');
      disp('  usage: 1) tumor data frame number');
      disp('  usage: 2) option string, support flag');
      disp('  usage:    letter d: use debug version, skip matlab conversion')
      disp('  usage: OUTPUT');
      disp('  usage: 1) time of the frame');
      disp('  usage: 2) data object');
      return
    end

    s1 = ['0000000' num2str(nn)];
    s2 = s1((length(s1)-4):length(s1));

    IN  = ['m' s2 '.dat'];
    IN2 = [IN '.gz'];

    IN2EXIST=exist(IN2,'file');

    if (IN2EXIST),
        system(['gunzip ' IN2]);
    end

    theend = 0;
    f = fopen(IN,'r');
    ipatch=0;

    [time,count] = fscanf(f, '%f', 1); 
    [maxlevel,count] = fscanf(f, '%d', 1);

    while(~theend)
    
      [level,count] =  fscanf(f, '%d', 1);
      [ndim,count]  =  fscanf(f, '%d', 1);
      [r,count] =  fscanf(f, '%d', 1);
      [nrvars,count]  =  fscanf(f, '%d', 1);

      if count ~= 0

        [dx(1),count] =  fscanf(f, '%f', 1);
        [dx(2),count] =  fscanf(f, '%f', 1);
        if ndim>2,
          [dx(3),count] =  fscanf(f, '%f', 1); 
        end

        [xl(1),count] =  fscanf(f, '%f', 1);
        [xl(2),count] =  fscanf(f, '%f', 1);
        if ndim>2,
          [xl(3),count] =  fscanf(f, '%f', 1); 
        end

        [xu(1),count] =  fscanf(f, '%f', 1);
        [xu(2),count] =  fscanf(f, '%f', 1);
        if ndim>2,
          [xu(3),count] =  fscanf(f, '%f', 1); 
        end

        [n(1),count] =  fscanf(f, '%d', 1);
        [n(2),count] =  fscanf(f, '%d', 1);
        if ndim>2,
          [n(3),count] =  fscanf(f, '%d', 1); 
        end
    
        [mg(1,1),count] =  fscanf(f, '%d', 1);
        [mg(1,2),count] =  fscanf(f, '%d', 1);
        [mg(2,1),count] =  fscanf(f, '%d', 1);
        [mg(2,2),count] =  fscanf(f, '%d', 1);
        if ndim>2,
          [mg(3,1),count] =  fscanf(f, '%d', 1);
          [mg(3,2),count] =  fscanf(f, '%d', 1);
        end

        ipatch = ipatch + 1;

        xu = xl+dx.*n;

        n=n+2;
        if ndim>2,
          tot=n(1)*n(2)*n(3);    
        else
          tot=n(1)*n(2);
        end
        B = zeros(nrvars,tot,'double');
        [B]=fscanf(f,'%f', [nrvars,tot]); % ghost layer included.
        if ndim>2,
          sp={linspace(xl(1)-dx(1)/2,xu(1)+dx(1)/2,n(1)); ...
                        linspace(xl(2)-dx(2)/2,xu(2)+dx(2)/2,n(2)); ...
                        linspace(xl(3)-dx(3)/2,xu(3)+dx(3)/2,n(3))};    
        else
          sp={linspace(xl(1)-dx(1)/2,xu(1)+dx(1)/2,n(1)); ...
                        linspace(xl(2)-dx(2)/2,xu(2)+dx(2)/2,n(2))};    
        end
    
        % convert grid to matlab patch format, cell node based
        for i=1:length(sp),
            vv=sp{i};
            sp2{i,1}=(vv(1:end-1)+vv(2:end))/2.0;
        end
        for ind=1:nrvars,
            if ndim>2,
                cc=zeros([n(2) n(1) n(3)],'double');
                for k=1:n(3)
                    for j=1:n(2)
                        for i=1:n(1)
                            cc(j,i,k) = B(ind,((k-1)*n(2)+j-1)*n(1)+i);
                        end;
                    end;
                end;
            else
                cc=zeros([n(2) n(1)],'double');
                for j=1:n(2)
                    for i=1:n(1)
                        cc(j,i)=B(ind,(j-1)*n(1)+i);
                    end
                end
            end
        
            % convert data to matlab patch format, cell node based
            if inopt('d',op),
                fd{ind,1}{ipatch,1}=cc;
                fd{ind,1}{ipatch,2}=sp;
                fd{ind,1}{ipatch,3}=level;
            else
                dd=center_to_node(cc);
                fd{ind,1}{ipatch,1}=dd;
                fd{ind,1}{ipatch,2}=sp2;
                fd{ind,1}{ipatch,3}=level;
            end
        end
      else
        theend = 1;
      end
    end;

    fclose(f);

    if (IN2EXIST),
        system(['gzip ' IN]);
    end

end
