(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     50136,       1042]
NotebookOptionsPosition[     48248,       1009]
NotebookOutlinePosition[     48585,       1024]
CellTagsIndexPosition[     48542,       1021]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "program", " ", "takes", " ", "in", " ", "the", " ", "g_i", 
     RowBox[{"(", 
      RowBox[{"p", "^", "e"}], ")"}], " ", "polynomials", " ", "found", " ", 
     "via", " ", "data", " ", "interpolation"}], ",", " ", 
    RowBox[{
    "and", " ", "applies", " ", "the", " ", "derived", " ", "combinatorial", 
     " ", "formula", " ", "to", " ", "obtain", " ", "the", " ", "f_i", 
     RowBox[{"(", 
      RowBox[{"p", "^", "e"}], ")"}], " ", 
     RowBox[{"polynomials", ".", " ", "It"}], " ", "takes", " ", "one", " ", 
     "input"}], ",", " ", 
    RowBox[{"e", " ", "for", " ", 
     RowBox[{"p", "^", "e"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "and", " ", "spits", " ", "out", " ", "all", " ", "of", " ", "the", " ", 
      "polynomial", " ", "coefficients", " ", "of", " ", "the", " ", "n", " ",
       "choose", " ", "i", " ", "terms", " ", "in", " ", "the", " ", 
      "expansion", " ", "of", " ", "f_n", 
      RowBox[{"(", 
       RowBox[{"p", "^", "e"}], ")"}], " ", "from", " ", "i"}], "=", 
     RowBox[{
      RowBox[{"2", " ", "to", " ", "i"}], "=", 
      RowBox[{"2", 
       RowBox[{"e", ".", " ", "See"}], " ", "the", " ", "derivation", " ", 
       "for", " ", "more", " ", "information", " ", "on", " ", "this", " ", 
       "combinatorial", " ", 
       RowBox[{"formula", "."}]}]}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.6476019851231947`*^9, 3.647602008952876*^9}, {
  3.647602110736191*^9, 3.647602143676652*^9}, {3.647602192363182*^9, 
  3.647602201858406*^9}, {3.6476022731538677`*^9, 
  3.647602478144479*^9}},ExpressionUUID->"dc3b9de9-8c3b-4be6-a3d0-\
c8916771fdcc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Combinatorica`\>\"", "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "is", " ", "the", " ", "table", " ", "of", " ", "the", " ", 
     "g_i", 
     RowBox[{"(", 
      RowBox[{"p", "^", "e"}], ")"}], " ", 
     RowBox[{"polynomials", ".", " ", "The"}], " ", "ijth", " ", "entry", " ",
      "gives", " ", "the", " ", "polynomial", " ", "g_", 
     RowBox[{"(", 
      RowBox[{"i", "+", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "^", "j"}], ")"}], " ", "--"}], " ", "I", " ", "omit", 
     " ", "the", " ", "first", " ", "row"}], ",", " ", 
    RowBox[{
     RowBox[{"for", " ", "i"}], "=", "1"}], ",", " ", 
    RowBox[{
    "since", " ", "these", " ", "polynomials", " ", "are", " ", "all", " ", 
     RowBox[{"zero", "."}]}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"polymatrix", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
        "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", 
        RowBox[{"1", "+", "p"}], ",", 
        RowBox[{"1", "+", 
         RowBox[{"3", "p"}]}], ",", 
        InterpretationBox[
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "p"}]}],
          Short[#, 5]& ],
         1 + 4 $CellContext`p], ",", 
        InterpretationBox[
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "p"}], "+", 
           SuperscriptBox["p", "2"]}],
          Short[#, 5]& ],
         1 + 4 $CellContext`p + $CellContext`p^2], ",", 
        RowBox[{
         RowBox[{"3", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", 
         RowBox[{"4", "p"}], " ", "+", " ", "1"}], ",", 
        RowBox[{
         RowBox[{"4", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", 
         RowBox[{"4", "p"}], " ", "+", " ", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", " ", "1", ",", 
        RowBox[{
         RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}], 
        ",", " ", 
        RowBox[{
         RowBox[{"7", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", "p", " ", "+", " ", "1"}],
         ",", 
        RowBox[{
         RowBox[{"p", "^", "3"}], " ", "+", " ", 
         RowBox[{"14", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", "p", " ", "+", " ", "1"}],
         ",", 
        RowBox[{
         RowBox[{"10", 
          RowBox[{"p", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"12", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", "p", " ", "+", " ", "1"}],
         ",", 
        RowBox[{
         RowBox[{"p", "^", "4"}], "+", 
         RowBox[{"26", 
          RowBox[{"p", "^", "3"}]}], "+", 
         RowBox[{"9", 
          RowBox[{"p", "^", "2"}]}], "+", "p", "+", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", " ", 
        RowBox[{
         RowBox[{"p", "^", "3"}], " ", "+", " ", 
         RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}], 
        ",", 
        RowBox[{
         RowBox[{"p", "^", "4"}], " ", "+", " ", 
         RowBox[{"11", 
          RowBox[{"p", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"2", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", "p", " ", "+", " ", "1"}],
         ",", 
        RowBox[{
         RowBox[{"15", 
          RowBox[{"p", "^", "4"}]}], " ", "+", " ", 
         RowBox[{"21", 
          RowBox[{"p", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"6", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", "p", " ", "+", " ", "1"}],
         ",", " ", 
        RowBox[{
         RowBox[{"p", "^", "5"}], "+", 
         RowBox[{"77", 
          RowBox[{"p", "^", "4"}]}], "-", 
         RowBox[{"13", 
          RowBox[{"p", "^", "3"}]}], "+", 
         RowBox[{"12", 
          RowBox[{"p", "^", "2"}]}], "+", "p", "+", "1"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
        RowBox[{
         RowBox[{"p", "^", "4"}], " ", "+", " ", 
         RowBox[{"p", "^", "3"}], " ", "+", " ", 
         RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}], 
        ",", 
        RowBox[{
         RowBox[{"p", "^", "6"}], " ", "+", " ", 
         RowBox[{"p", "^", "5"}], " ", "+", " ", 
         RowBox[{"17", 
          RowBox[{"p", "^", "4"}]}], " ", "+", " ", 
         RowBox[{"2", 
          RowBox[{"p", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"2", 
          RowBox[{"p", "^", "2"}]}], " ", "+", " ", "p", " ", "+", " ", "1"}],
         ",", " ", 
        RowBox[{
         RowBox[{"16", 
          RowBox[{"p", "^", "6"}]}], "+", 
         RowBox[{"31", 
          RowBox[{"p", "^", "5"}]}], "+", 
         RowBox[{"22", 
          RowBox[{"p", "^", "4"}]}], "+", 
         RowBox[{"22", 
          RowBox[{"p", "^", "3"}]}], "+", 
         RowBox[{"2", 
          RowBox[{"p", "^", "2"}]}], "+", "p", "+", "1"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "0", ",", "0", ",", " ", "0", ",", "0", ",", "1", ",", 
        RowBox[{
         RowBox[{"p", "^", "5"}], " ", "+", " ", 
         RowBox[{"p", "^", "4"}], " ", "+", " ", 
         RowBox[{"p", "^", "3"}], " ", "+", " ", 
         RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}], 
        ",", 
        RowBox[{
         RowBox[{"p", "^", "8"}], "+", 
         RowBox[{"p", "^", "7"}], "+", 
         RowBox[{"2", 
          RowBox[{"p", "^", "6"}]}], "+", 
         RowBox[{"23", 
          RowBox[{"p", "^", "5"}]}], "+", 
         RowBox[{"3", 
          RowBox[{"p", "^", "4"}]}], "+", 
         RowBox[{"2", 
          RowBox[{"p", "^", "3"}]}], "+", 
         RowBox[{"2", 
          RowBox[{"p", "^", "2"}]}], "+", "p", "+", "1"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", " ", "0", ",", "0", ",", " ", "0", ",", " ", "0", ",", "0", 
        ",", "1", ",", " ", 
        RowBox[{
         RowBox[{"p", "^", "6"}], " ", "+", " ", 
         RowBox[{"p", "^", "5"}], " ", "+", " ", 
         RowBox[{"p", "^", "4"}], " ", "+", " ", 
         RowBox[{"p", "^", "3"}], " ", "+", " ", 
         RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", " ", "0", ",", "0", ",", " ", "0", ",", " ", "0", ",", "0", 
        ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "To", " ", "calculate", " ", "the", " ", "polynomials", " ", 
     "coefficients", " ", "f_i", " ", "in", " ", "the", " ", "expansion", " ",
      "of", " ", "f_n", 
     RowBox[{"(", 
      RowBox[{"p", "^", "e"}], ")"}]}], ",", " ", 
    RowBox[{
     RowBox[{"set", " ", "\"\<exponent\>\"", " ", "equal", " ", "to", " ", 
      RowBox[{"e", ".", " ", "The"}], " ", "program", " ", "will", " ", 
      "give", " ", "all", " ", "f_is", " ", "for", " ", "i"}], "=", 
     RowBox[{
      RowBox[{"2", " ", "to", " ", "i"}], "=", 
      RowBox[{"2", 
       RowBox[{"e", ".", " ", "\"\<exponent\>\""}], " ", "is", " ", "the", 
       " ", "ONLY", " ", "input", " ", "for", " ", "this", " ", 
       RowBox[{"program", "."}]}]}]}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exponent", " ", "=", "8"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"valueofi", "=", "2"}], ",", 
   RowBox[{"valueofi", "\[LessEqual]", 
    RowBox[{"2", "*", "exponent"}]}], ",", 
   RowBox[{"valueofi", "++"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"runningsum", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "This", " ", "part", " ", "of", " ", "the", " ", "program", " ", 
       "gives", " ", "the", " ", "list", " ", "of", " ", "all", " ", 
       "partitions", " ", "of", " ", "i", " ", "with", " ", "minimum", " ", 
       "value", " ", "2.", " ", "In", " ", "the", " ", "notation", " ", "of", 
       " ", "the", " ", "earlier", " ", "write", " ", "up"}], ",", " ", 
      RowBox[{"this", " ", "is", " ", "the", " ", "set", " ", "P_i"}], ",", 
      " ", 
      RowBox[{"which", " ", "is", " ", "to", " ", "be", " ", "summed", " ", 
       RowBox[{"over", ".", " ", "This"}], " ", "set", " ", "is", " ", 
       "named", " ", 
       RowBox[{"partitionsofi", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"listofpartitions", " ", "=", " ", 
     RowBox[{"Partitions", "[", "valueofi", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"length", " ", "=", " ", 
     RowBox[{"Length", "[", "listofpartitions", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"newlistofpartitions", " ", "=", " ", 
     RowBox[{"Reverse", "[", "listofpartitions", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "length"}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"newlistofpartitions", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"Reverse", "[", 
         RowBox[{"newlistofpartitions", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"partitionsofi", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "length"}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"newlistofpartitions", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "1"}], ",", 
        RowBox[{"partitionsofi", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"partitionsofi", ",", 
           RowBox[{"newlistofpartitions", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", "Null"}], "]"}]}],
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", 
       RowBox[{"Length", "[", "partitionsofi", "]"}]}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"partitionsofi", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{"Reverse", "[", 
         RowBox[{"partitionsofi", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"numpartitionsofi", " ", "=", " ", 
     RowBox[{"Length", "[", "partitionsofi", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "For", " ", "each", " ", "partition", " ", "in", " ", "the", " ", 
       "list", " ", "partitionsofi"}], ",", " ", 
      RowBox[{"generate", " ", 
       RowBox[{"(", "1", ")"}], " ", "the", " ", "combinatorial", " ", 
       "constant", " ", "S_lambda"}], ",", " ", 
      RowBox[{"and", " ", 
       RowBox[{"(", "2", ")"}], " ", "the", " ", "set", " ", 
       RowBox[{"K", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "numpartitionsofi"}], ",", 
      RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"lambda", " ", "=", " ", 
        RowBox[{"partitionsofi", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"l", " ", "=", " ", 
        RowBox[{"Length", "[", "lambda", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "The", " ", "combinatorial", " ", "constant", " ", "S_lambda", " ", 
         "is", " ", "the", " ", "number", " ", "of", " ", "set", " ", 
         "partitions", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"i", ".", "e", ".", " ", "compositions"}], "/", 
            "ordered"}], " ", "partitions"}], ")"}], " ", "of", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "...", ",", "n"}], "}"}], " ", "with", " ", 
         "numerical", " ", "type", " ", 
         RowBox[{"lambda", "."}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"association", " ", "=", " ", 
        RowBox[{"Counts", "[", "lambda", "]"}]}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"product", " ", "=", " ", "1"}], ";", "\[IndentingNewLine]", 
       RowBox[{"norepeats", " ", "=", " ", 
        RowBox[{"DeleteDuplicates", "[", "lambda", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"k", "=", "1"}], ",", 
         RowBox[{"k", "\[LessEqual]", " ", 
          RowBox[{"Length", "[", "association", "]"}]}], ",", 
         RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{"product", " ", "=", " ", 
          RowBox[{"product", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"association", "[", 
               RowBox[{"[", "k", "]"}], "]"}], "!"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"norepeats", "[", 
                 RowBox[{"[", "k", "]"}], "]"}], "!"}], ")"}], "^", 
              RowBox[{"association", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}]}], ")"}]}]}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"S", " ", "=", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"valueofi", "!"}], ")"}], "/", "product"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Create", " ", "the", " ", "set", " ", 
          RowBox[{"K", ".", " ", "If"}], " ", "we", " ", "fix", " ", "a", " ",
           "partition", " ", "lambda", " ", "and", " ", "write", " ", "its", 
          " ", "length", " ", "as", " ", "l"}], ",", " ", 
         RowBox[{
          RowBox[{
          "this", " ", "set", " ", "is", " ", "to", " ", "be", " ", "the", 
           " ", "collection", " ", "of", " ", "all", " ", "l"}], "-", 
          RowBox[{
          "tuples", " ", "of", " ", "integers", " ", "which", " ", "sum", " ",
            "to", " ", "the", " ", "exponent", " ", "e"}]}], ",", " ", 
         RowBox[{
          RowBox[{
          "and", " ", "such", " ", "that", " ", "the", " ", "tuple_j"}], " ", 
          "\[GreaterEqual]", " ", 
          RowBox[{"lambda_j", " ", "-", 
           RowBox[{"1.", " ", 
            RowBox[{"We", "'"}], "re", " ", "going", " ", "to", " ", "sum", 
            " ", "over", " ", "all", " ", "elements", " ", "k", " ", "in", 
            " ", 
            RowBox[{"K", "."}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"candidates", " ", "=", " ", 
        RowBox[{"Compositions", "[", 
         RowBox[{"exponent", ",", "l"}], "]"}]}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"K", " ", "=", " ", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"k", "=", "1"}], ",", 
         RowBox[{"k", "\[LessEqual]", 
          RowBox[{"Length", "[", "candidates", "]"}]}], ",", 
         RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"test", " ", "=", " ", 
           RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", "1"}], ",", 
            RowBox[{"j", "\[LessEqual]", 
             RowBox[{"Length", "[", 
              RowBox[{"candidates", "[", 
               RowBox[{"[", "k", "]"}], "]"}], "]"}]}], ",", 
            RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{"test", " ", "=", " ", 
             RowBox[{"Append", "[", 
              RowBox[{"test", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"candidates", "[", 
                  RowBox[{"[", "k", "]"}], "]"}], "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "-", 
                RowBox[{"lambda", "[", 
                 RowBox[{"[", "j", "]"}], "]"}]}]}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Min", "[", "test", "]"}], "\[GreaterEqual]", " ", 
             RowBox[{"-", "1"}]}], ",", 
            RowBox[{"K", " ", "=", " ", 
             RowBox[{"Append", "[", 
              RowBox[{"K", ",", 
               RowBox[{"List", "[", 
                RowBox[{"candidates", "[", 
                 RowBox[{"[", "k", "]"}], "]"}], "]"}]}], "]"}]}], ",", 
            "Null"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "For", " ", "each", " ", "element", " ", "k", " ", "of", " ", "K"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"you", "'"}], "re", " ", "going", " ", "to", " ", "take", 
          " ", "the", " ", "product", " ", "of", " ", "the", " ", "g_lambda", 
          "_m", 
          RowBox[{"(", 
           RowBox[{"p", "^", "k_m"}], ")"}], " ", "polynomials"}], ",", " ", 
         RowBox[{
         "where", " ", "lambda_m", " ", "is", " ", "the", " ", "mth", " ", 
          "entry", " ", "in", " ", "our", " ", "partition", " ", 
          RowBox[{"lambda", " ", "--"}], " ", "the", " ", "one", " ", "from", 
          " ", "the", " ", "outer", " ", 
          RowBox[{"sum", " ", "--"}], " ", "and", " ", "k_m", " ", "is", " ", 
          "the", " ", "mth", " ", "entry", " ", "of", " ", "the", " ", 
          "element", " ", "k", " ", "of", " ", "K", " ", "that", " ", 
          "corresponds", " ", "to", " ", "the", " ", "inner", " ", 
          RowBox[{"sum", ".", " ", "Then"}], " ", "sum", " ", "all", " ", 
          "of", " ", "these", " ", 
          RowBox[{"products", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"innersum", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"j", "=", "1"}], ",", 
         RowBox[{"j", "\[LessEqual]", 
          RowBox[{"Length", "[", "K", "]"}]}], ",", 
         RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"tuple", "=", 
           RowBox[{"K", "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Create", " ", "the", " ", "product"}], "*)"}], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"innerproduct", " ", "=", " ", "1"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"m", "=", "1"}], ",", 
            RowBox[{"m", "\[LessEqual]", "l"}], ",", 
            RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"row", " ", "=", " ", 
              RowBox[{
               RowBox[{"lambda", "[", 
                RowBox[{"[", "m", "]"}], "]"}], "-", "1"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"column", " ", "=", " ", 
              RowBox[{"tuple", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "m"}], "]"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"innerproduct", " ", "=", " ", 
              RowBox[{"innerproduct", "*", 
               RowBox[{"polymatrix", "[", 
                RowBox[{"[", 
                 RowBox[{"row", ",", "column"}], "]"}], "]"}]}]}], ";"}]}], 
           "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "Sum", " ", "over", " ", "all", " ", "k", " ", "in", " ", "K"}], 
           "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"innersum", "=", 
           RowBox[{"innersum", "+", "innerproduct"}]}], ";"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "Add", " ", "the", " ", "combinatorial", " ", "constant", " ", 
          "times", " ", "the", " ", "inner", " ", "sum", " ", "to", " ", 
          "the", " ", "running", " ", "total", " ", "of", " ", "the", " ", 
          "outer", " ", "sum"}], ",", " ", 
         RowBox[{
          RowBox[{"i", ".", "e", ".", " ", "the"}], " ", "summation", " ", 
          "over", " ", "all", " ", "lambda", " ", "in", " ", 
          RowBox[{"P", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"runningsum", "=", 
        RowBox[{"runningsum", "+", 
         RowBox[{"S", "*", "innersum"}]}]}], ";"}]}], "\[IndentingNewLine]", 
     "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"result", " ", "=", " ", 
     RowBox[{"StringForm", "[", 
      RowBox[{
      "\"\<The polynomial coefficient f_i for n choose `` is ``.\>\"", ",", 
       "valueofi", ",", 
       RowBox[{"Expand", "[", "runningsum", "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "result", "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.647172597689926*^9, 3.647172604364602*^9}, {
   3.647172648707382*^9, 3.647172780905219*^9}, {3.6471729520679913`*^9, 
   3.647172986681744*^9}, {3.647173026627009*^9, 3.647173031839622*^9}, {
   3.647173080416658*^9, 3.647173231145926*^9}, {3.647173309202197*^9, 
   3.647173323560417*^9}, {3.647173363686957*^9, 3.647173370975247*^9}, {
   3.647173838962955*^9, 3.647173882114245*^9}, 3.647173941010948*^9, {
   3.64717397549651*^9, 3.647173976353215*^9}, {3.6471795577437143`*^9, 
   3.6471795881079903`*^9}, {3.647179619229033*^9, 3.647179620226945*^9}, {
   3.6471796749130793`*^9, 3.64717971331364*^9}, {3.647179824157592*^9, 
   3.647179827116971*^9}, {3.647179860174988*^9, 3.6471799068905687`*^9}, {
   3.647180428456218*^9, 3.647180454268301*^9}, {3.64718068928848*^9, 
   3.647180691221636*^9}, {3.647180732952158*^9, 3.647180737597575*^9}, {
   3.647180782895648*^9, 3.647180783869245*^9}, {3.6471808433566027`*^9, 
   3.647180903762644*^9}, {3.647181142004643*^9, 3.647181142777857*^9}, {
   3.647181196459704*^9, 3.647181230801902*^9}, {3.647181307608325*^9, 
   3.6471813908920507`*^9}, {3.647181426268896*^9, 3.647181451244177*^9}, {
   3.647181730813857*^9, 3.647181768585968*^9}, {3.6471818391704397`*^9, 
   3.647181842991591*^9}, {3.647181924559416*^9, 3.647181934613736*^9}, {
   3.647181979532454*^9, 3.647182006109509*^9}, {3.647182095091196*^9, 
   3.6471820953372297`*^9}, {3.647182164146099*^9, 3.647182172417288*^9}, {
   3.647182316126243*^9, 3.6471823199968557`*^9}, {3.6471823595251083`*^9, 
   3.647182416585973*^9}, {3.647182575695404*^9, 3.6471825813322573`*^9}, {
   3.647182635093667*^9, 3.6471826610432243`*^9}, {3.647184191756968*^9, 
   3.6471842038923683`*^9}, {3.6471843544449673`*^9, 
   3.6471843761343107`*^9}, {3.64718450148247*^9, 3.647184662100863*^9}, {
   3.647184724694644*^9, 3.647184756275527*^9}, {3.647184938985298*^9, 
   3.647185237542495*^9}, {3.6471853813328247`*^9, 3.6471854083308268`*^9}, {
   3.647185901640088*^9, 3.6471859417174177`*^9}, {3.647186001582095*^9, 
   3.647186016452807*^9}, {3.647186614460046*^9, 3.647186630018002*^9}, {
   3.6471866741883698`*^9, 3.647186686464623*^9}, {3.647186979843672*^9, 
   3.647187031151963*^9}, {3.647187154919908*^9, 3.6471871735324383`*^9}, {
   3.647187377257002*^9, 3.647187383670725*^9}, {3.6471875123801327`*^9, 
   3.647187516244225*^9}, {3.647187580658865*^9, 3.6471876050551863`*^9}, {
   3.64718782293929*^9, 3.647188032734758*^9}, {3.647188079983348*^9, 
   3.647188185258349*^9}, 3.647188221570868*^9, {3.64718835740702*^9, 
   3.647188363301956*^9}, {3.6471885321627274`*^9, 3.6471885378342943`*^9}, {
   3.647188642527705*^9, 3.647188678605961*^9}, {3.6471887145872507`*^9, 
   3.647188714847703*^9}, {3.647188808516816*^9, 3.647188855225916*^9}, {
   3.6471888864825583`*^9, 3.647189021693592*^9}, {3.6471891284682817`*^9, 
   3.647189185635104*^9}, {3.647189222922914*^9, 3.647189303981494*^9}, {
   3.647189363103293*^9, 3.6471893890851107`*^9}, {3.647189443445074*^9, 
   3.647189598433198*^9}, {3.647189674784232*^9, 3.647189675125057*^9}, {
   3.647189790483906*^9, 3.647189792737534*^9}, {3.647190070262532*^9, 
   3.647190076004922*^9}, {3.647190132158063*^9, 3.647190132468349*^9}, {
   3.647190164770293*^9, 3.64719019096817*^9}, {3.6471902239531612`*^9, 
   3.647190238918251*^9}, {3.647190302671294*^9, 3.6471903093399763`*^9}, 
   3.647191151255507*^9, {3.64719219392203*^9, 3.647192248969266*^9}, {
   3.647192325736616*^9, 3.647192428708211*^9}, {3.647192486075799*^9, 
   3.6471925204501762`*^9}, {3.647274216107955*^9, 3.647274407876371*^9}, {
   3.647274482532991*^9, 3.647274694252179*^9}, {3.6472748189693727`*^9, 
   3.647274861431562*^9}, {3.6472752818756723`*^9, 3.6472752858035603`*^9}, {
   3.64727538263908*^9, 3.647275382775511*^9}, {3.6472754349930477`*^9, 
   3.647275435086521*^9}, {3.647275466128634*^9, 3.647275466963766*^9}, {
   3.647277306439074*^9, 3.6472773730849257`*^9}, {3.6472774468492613`*^9, 
   3.6472774489602013`*^9}, {3.647277492304077*^9, 3.6472775005109158`*^9}, {
   3.647277585074256*^9, 3.647277611300699*^9}, {3.647277651498466*^9, 
   3.647277865908019*^9}, {3.6472779031898403`*^9, 3.647277914698616*^9}, {
   3.647278020559812*^9, 3.647278046665003*^9}, {3.647278105887414*^9, 
   3.6472781102353573`*^9}, {3.64727855181108*^9, 3.647278554793043*^9}, {
   3.647278609591934*^9, 3.647278613629463*^9}, {3.647278687475963*^9, 
   3.647278697779952*^9}, {3.647278735530868*^9, 3.647278799489457*^9}, {
   3.647278830841201*^9, 3.64727885047901*^9}, {3.6472789332940607`*^9, 
   3.647278933394561*^9}, {3.647279180318862*^9, 3.647279315110915*^9}, {
   3.647279378694552*^9, 3.6472794085169992`*^9}, {3.6472794403489523`*^9, 
   3.6472794510263653`*^9}, {3.647279502730946*^9, 3.647279528432683*^9}, {
   3.6473453021412907`*^9, 3.647345436167556*^9}, {3.6473455013885927`*^9, 
   3.647345501511037*^9}, {3.64734554206988*^9, 3.6473455632993193`*^9}, {
   3.647345633429028*^9, 3.647345636797927*^9}, {3.6473456817302217`*^9, 
   3.6473457114164467`*^9}, {3.6473457878302193`*^9, 3.647345793643306*^9}, {
   3.647345889799096*^9, 3.647345896108466*^9}, {3.647346231170236*^9, 
   3.647346231769758*^9}, {3.647346295597887*^9, 3.6473462961459312`*^9}, {
   3.647346383613472*^9, 3.647346403830771*^9}, {3.647346514507867*^9, 
   3.647346560861981*^9}, {3.647346691978697*^9, 3.647346722573969*^9}, {
   3.647346958651458*^9, 3.6473469587465353`*^9}, {3.647356034226963*^9, 
   3.6473560344262257`*^9}, {3.647356569782941*^9, 3.647356569948977*^9}, {
   3.6473568125994797`*^9, 3.6473568130747633`*^9}, {3.647356850784211*^9, 
   3.6473568539996853`*^9}, {3.647356899211568*^9, 3.64735692456816*^9}, {
   3.647360819347711*^9, 3.647360840322073*^9}, {3.6473612496904783`*^9, 
   3.6473612499593573`*^9}, {3.647361296478744*^9, 3.6473613036518583`*^9}, {
   3.647361342121982*^9, 3.647361389420825*^9}, {3.647361428448949*^9, 
   3.647361433369157*^9}, {3.647361490338328*^9, 3.647361512108019*^9}, {
   3.6473615865220222`*^9, 3.647361673687973*^9}, {3.647361711845463*^9, 
   3.6473617191632967`*^9}, {3.647361807725601*^9, 3.647362059454896*^9}, {
   3.647362124559173*^9, 3.647362124621554*^9}, {3.6473621705255747`*^9, 
   3.647362170620204*^9}, {3.647362348596222*^9, 3.647362348721018*^9}, {
   3.647362451801772*^9, 3.647362453155178*^9}, {3.647601686259268*^9, 
   3.6476018022888107`*^9}, {3.6476019347313538`*^9, 
   3.6476019417457647`*^9}, {3.647602769370001*^9, 3.647602841169117*^9}, {
   3.647602892218828*^9, 3.6476029309687033`*^9}, {3.6476029645305567`*^9, 
   3.6476029709184313`*^9}, {3.647603184272129*^9, 3.647603297575355*^9}, {
   3.771718822709948*^9, 3.77171884872823*^9}, {3.771718890163044*^9, 
   3.771718923683291*^9}, 3.7744414738831053`*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"31cd060a-94aa-47a7-bedc-01c7b5d34ae7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"2\\\"}]\\) is \\!\\(\\*RowBox[{\\\"1\\\"}]\\).\"\>",
  StringForm["The polynomial coefficient f_i for n choose `` is ``.", 2, 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189248388033`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"a4163f8f-0ddb-4ac4-a2da-36647e3058d6"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"3\\\"}]\\) is \\!\\(\\*RowBox[{\\\"1\\\", \\\"+\\\", \
RowBox[{\\\"4\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", RowBox[{\\\"4\\\", \\\" \
\\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 3, 1 + 
   4 $CellContext`p + 4 $CellContext`p^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189248419323`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"797c4699-8164-460e-a8a8-357ee62ea5ff"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"4\\\"}]\\) is \\!\\(\\*RowBox[{\\\"22\\\", \\\"+\\\", \\\
\"p\\\", \\\"+\\\", RowBox[{\\\"9\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"2\\\"]}], \\\"+\\\", RowBox[{\\\"26\\\", \\\" \\\", \
SuperscriptBox[\\\"p\\\", \\\"3\\\"]}], \\\"+\\\", SuperscriptBox[\\\"p\\\", \
\\\"4\\\"]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 4, 
   22 + $CellContext`p + 9 $CellContext`p^2 + 
   26 $CellContext`p^3 + $CellContext`p^4],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189248451643`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"81022b40-3ae9-42bf-ab64-5e9e91a1ac06"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"5\\\"}]\\) is \\!\\(\\*RowBox[{\\\"61\\\", \\\"+\\\", \
RowBox[{\\\"161\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", RowBox[{\\\"52\\\", \
\\\" \\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}], \\\"-\\\", \
RowBox[{\\\"13\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"3\\\"]}], \
\\\"+\\\", RowBox[{\\\"77\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"4\\\"]}], \\\"+\\\", SuperscriptBox[\\\"p\\\", \\\"5\\\"]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 5, 61 + 
   161 $CellContext`p + 52 $CellContext`p^2 - 13 $CellContext`p^3 + 
   77 $CellContext`p^4 + $CellContext`p^5],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189248471622`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"4082abf5-e416-4c13-846e-9237b40d48a6"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"6\\\"}]\\) is \\!\\(\\*RowBox[{\\\"441\\\", \\\"+\\\", \
RowBox[{\\\"301\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", RowBox[{\\\"702\\\", \
\\\" \\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}], \\\"+\\\", RowBox[{\\\"187\
\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"3\\\"]}], \\\"+\\\", \
RowBox[{\\\"22\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"4\\\"]}], \
\\\"+\\\", RowBox[{\\\"31\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"5\\\"]}], \\\"+\\\", RowBox[{\\\"16\\\", \\\" \\\", \
SuperscriptBox[\\\"p\\\", \\\"6\\\"]}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 6, 441 + 
   301 $CellContext`p + 702 $CellContext`p^2 + 187 $CellContext`p^3 + 
   22 $CellContext`p^4 + 31 $CellContext`p^5 + 16 $CellContext`p^6],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.771718924848859*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"914ce04f-0358-4b02-a2ff-7368193e03d9"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"7\\\"}]\\) is \\!\\(\\*RowBox[{\\\"1800\\\", \\\"+\\\", \
RowBox[{\\\"3074\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", \
RowBox[{\\\"1206\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}], \
\\\"+\\\", RowBox[{\\\"1080\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"3\\\
\"]}], \\\"+\\\", RowBox[{\\\"339\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"4\\\"]}], \\\"+\\\", RowBox[{\\\"23\\\", \\\" \\\", \
SuperscriptBox[\\\"p\\\", \\\"5\\\"]}], \\\"+\\\", RowBox[{\\\"2\\\", \\\" \\\
\", SuperscriptBox[\\\"p\\\", \\\"6\\\"]}], \\\"+\\\", SuperscriptBox[\\\"p\\\
\", \\\"7\\\"], \\\"+\\\", SuperscriptBox[\\\"p\\\", \\\"8\\\"]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 7, 1800 + 
   3074 $CellContext`p + 1206 $CellContext`p^2 + 1080 $CellContext`p^3 + 
   339 $CellContext`p^4 + 23 $CellContext`p^5 + 
   2 $CellContext`p^6 + $CellContext`p^7 + $CellContext`p^8],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.771718924850486*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"ff96d350-4bf6-44d5-9d69-277605b17013"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"8\\\"}]\\) is \\!\\(\\*RowBox[{\\\"8933\\\", \\\"+\\\", \
RowBox[{\\\"9073\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", \
RowBox[{\\\"9374\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}], \
\\\"+\\\", RowBox[{\\\"1093\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"3\\\
\"]}], \\\"+\\\", RowBox[{\\\"652\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"4\\\"]}], \\\"+\\\", RowBox[{\\\"29\\\", \\\" \\\", \
SuperscriptBox[\\\"p\\\", \\\"5\\\"]}], \\\"+\\\", RowBox[{\\\"29\\\", \\\" \
\\\", SuperscriptBox[\\\"p\\\", \\\"6\\\"]}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 8, 8933 + 
   9073 $CellContext`p + 9374 $CellContext`p^2 + 1093 $CellContext`p^3 + 
   652 $CellContext`p^4 + 29 $CellContext`p^5 + 29 $CellContext`p^6],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189248521967`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"2537ad5a-019f-4683-9736-6af418040766"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"9\\\"}]\\) is \\!\\(\\*RowBox[{\\\"37201\\\", \\\"+\\\", \
RowBox[{\\\"39810\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", RowBox[{\\\"15324\\\
\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}], \\\"+\\\", \
RowBox[{\\\"6420\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"3\\\"]}], \
\\\"+\\\", RowBox[{\\\"498\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"4\\\"]}], \\\"+\\\", RowBox[{\\\"36\\\", \\\" \\\", \
SuperscriptBox[\\\"p\\\", \\\"5\\\"]}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 9, 37201 + 
   39810 $CellContext`p + 15324 $CellContext`p^2 + 6420 $CellContext`p^3 + 
   498 $CellContext`p^4 + 36 $CellContext`p^5],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.771718924860623*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"9092329b-9516-4ddb-9c13-496ad08ca406"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"10\\\"}]\\) is \\!\\(\\*RowBox[{\\\"148551\\\", \
\\\"+\\\", RowBox[{\\\"103320\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", \
RowBox[{\\\"46200\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}], \
\\\"+\\\", RowBox[{\\\"3150\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"3\\\
\"]}], \\\"+\\\", RowBox[{\\\"630\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"4\\\"]}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 10, 148551 + 
   103320 $CellContext`p + 46200 $CellContext`p^2 + 3150 $CellContext`p^3 + 
   630 $CellContext`p^4],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.771718924895989*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"06d98b35-f95b-4edf-8ea7-3a85f8149d4e"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"11\\\"}]\\) is \\!\\(\\*RowBox[{\\\"510730\\\", \
\\\"+\\\", RowBox[{\\\"243705\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", \
RowBox[{\\\"41580\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"2\\\"]}], \
\\\"+\\\", RowBox[{\\\"6930\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \\\"3\\\
\"]}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 11, 510730 + 
   243705 $CellContext`p + 41580 $CellContext`p^2 + 6930 $CellContext`p^3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189249390793`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"7f213b5a-fa46-42f9-b99f-551ec3da5e60"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"12\\\"}]\\) is \\!\\(\\*RowBox[{\\\"1474165\\\", \\\"+\\\
\", RowBox[{\\\"329175\\\", \\\" \\\", \\\"p\\\"}], \\\"+\\\", \
RowBox[{\\\"51975\\\", \\\" \\\", SuperscriptBox[\\\"p\\\", \
\\\"2\\\"]}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 12, 1474165 + 
   329175 $CellContext`p + 51975 $CellContext`p^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189249901037`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"aa8fd58d-dc8e-49a0-aa6d-cc8cd11fec5e"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"13\\\"}]\\) is \\!\\(\\*RowBox[{\\\"3258255\\\", \\\"+\\\
\", RowBox[{\\\"270270\\\", \\\" \\\", \\\"p\\\"}]}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 13, 3258255 + 
   270270 $CellContext`p],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189250680847`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"ce20f581-9f41-4520-bf95-e1c6bd400e3a"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"14\\\"}]\\) is \
\\!\\(\\*RowBox[{\\\"5045040\\\"}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 14, 5045040],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189252409763`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"8e5bbaae-060b-472a-8f61-849b3347bfc1"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"15\\\"}]\\) is \
\\!\\(\\*RowBox[{\\\"4729725\\\"}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 15, 4729725],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.771718925452303*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"96fec7ff-49ae-4ad2-8e17-645fd6f4ffc3"],

Cell[BoxData[
 InterpretationBox["\<\"The polynomial coefficient f_i for n choose \
\\!\\(\\*RowBox[{\\\"16\\\"}]\\) is \
\\!\\(\\*RowBox[{\\\"2027025\\\"}]\\).\"\>",
  StringForm[
  "The polynomial coefficient f_i for n choose `` is ``.", 16, 2027025],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64736200810034*^9, 3.647362020202813*^9}, 
   3.647362060141679*^9, 3.647362125151054*^9, 3.647362171675799*^9, 
   3.647362349195705*^9, 3.647362457291481*^9, 3.6476018114180098`*^9, 
   3.647601948185738*^9, 3.647602808226406*^9, 3.6476028423137903`*^9, 
   3.647602907910334*^9, 3.647602972690189*^9, 3.6476031608048887`*^9, {
   3.771718786998993*^9, 3.7717188131995487`*^9}, 3.7717189259327374`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"81ffdc06-1b6e-49a2-923c-428d864b5eba"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{911, 805},
WindowMargins->{{198, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1720, 37, 157, "Input",ExpressionUUID->"dc3b9de9-8c3b-4be6-a3d0-c8916771fdcc"],
Cell[CellGroupData[{
Cell[2303, 61, 29179, 629, 2494, "Input",ExpressionUUID->"31cd060a-94aa-47a7-bedc-01c7b5d34ae7"],
Cell[CellGroupData[{
Cell[31507, 694, 796, 13, 24, "Print",ExpressionUUID->"a4163f8f-0ddb-4ac4-a2da-36647e3058d6"],
Cell[32306, 709, 982, 17, 25, "Print",ExpressionUUID->"797c4699-8164-460e-a8a8-357ee62ea5ff"],
Cell[33291, 728, 1130, 20, 25, "Print",ExpressionUUID->"81022b40-3ae9-42bf-ab64-5e9e91a1ac06"],
Cell[34424, 750, 1276, 21, 25, "Print",ExpressionUUID->"4082abf5-e416-4c13-846e-9237b40d48a6"],
Cell[35703, 773, 1424, 23, 25, "Print",ExpressionUUID->"914ce04f-0358-4b02-a2ff-7368193e03d9"],
Cell[37130, 798, 1574, 25, 25, "Print",ExpressionUUID->"ff96d350-4bf6-44d5-9d69-277605b17013"],
Cell[38707, 825, 1436, 23, 25, "Print",ExpressionUUID->"2537ad5a-019f-4683-9736-6af418040766"],
Cell[40146, 850, 1334, 22, 25, "Print",ExpressionUUID->"9092329b-9516-4ddb-9c13-496ad08ca406"],
Cell[41483, 874, 1234, 21, 25, "Print",ExpressionUUID->"06d98b35-f95b-4edf-8ea7-3a85f8149d4e"],
Cell[42720, 897, 1124, 19, 25, "Print",ExpressionUUID->"7f213b5a-fa46-42f9-b99f-551ec3da5e60"],
Cell[43847, 918, 1016, 18, 25, "Print",ExpressionUUID->"aa8fd58d-dc8e-49a0-aa6d-cc8cd11fec5e"],
Cell[44866, 938, 902, 16, 24, "Print",ExpressionUUID->"ce20f581-9f41-4520-bf95-e1c6bd400e3a"],
Cell[45771, 956, 815, 15, 24, "Print",ExpressionUUID->"8e5bbaae-060b-472a-8f61-849b3347bfc1"],
Cell[46589, 973, 813, 15, 24, "Print",ExpressionUUID->"96fec7ff-49ae-4ad2-8e17-645fd6f4ffc3"],
Cell[47405, 990, 815, 15, 24, "Print",ExpressionUUID->"81ffdc06-1b6e-49a2-923c-428d864b5eba"]
}, Open  ]]
}, Open  ]]
}
]
*)

