% B R I E F  C O D E  D E S C R I P T I O N :
%
% full_pivoting finds the position of the biggest element of the matrix A
%
% (in absolute value) and moves this element to the ( k , k ) position
%
% using column and row operations. Of course, it also interchanges the
%
% associated rows in b for each row operation applied to A .
%
function M = full_pivoting( A , b , k )
%
% I N P U T : A = Matrix of dimension m x n, b = vector of dimension n x 1
%
%            and k = scalar from 1 to minimum( m , n ) .
%
% O U T P U T : M = [A b]; after A and b where operated so that the biggest
%
% elemnt of A is in the ( k , k ) position of A .
%
% E X A M P L E : Type in the command window of Matlab: 
%
%   full_pivoting( [ 1 2 3 ; 5 0 2 ; 1 7 0 ] , transpose( [ 1 -1 3 ] ), 2 )
%
[ m , n ] = size( A ) ;
%
%-------------- Looking for the pivot ------------------------
i_max = k ;
j_max = k ;
%
for i = k : m
    for j = k : n
        if abs( A( i , j ) ) > abs( A( i_max , j_max ) )
            i_max = i ;
            j_max = j ;
        end
    end
end

%----------- Seending pivot to the position (k,k) -----------------------
%
% Interchanging columns
   A_k = A( : , k ) ;
   A_max = A( : , j_max) ;
   A( : , k ) = A_max ; 
   A( : , j_max ) = A_k ;

% Interchanging Rows:
   v_k = A( k , : ) ;
   v_max = A( i_max , : ) ;
   A( k , : ) = v_max ; 
   A( i_max , : ) = v_k ;
   b_k = b( k ) ;
   b_max = b( i_max ) ;
   b( k ) = b_max ;
   b( i_max ) = b_k ;
%
   M = [ A b ] ;
