% B R I E F  C O D E  D E S C R I P T I O N :
%
% Given the system Ax = b the function gaussian finds the vector x using 
%
% full pivoting and applying gaussian elimination .  
%
% W A R N I N G : Before run this code be sure that you have the files
%
% full_pivoting.m and permutations.m saved in the same folder that
%
% gaussian.m . 
%
% I N P U T : A = Non singular matrix of dimension n x n, b = vector of 
%
% dimension n x 1 and Tol = Tolerance.
%
% O U T P U T : x = vector solution of the system Ax = b .
%
% E X A M P L E : Type in the command window of Matlab: 
%
%           gaussian( [ 1 2 3 ; 5 0 2 ; 1 7 0 ] , transpose( [ 1 -1 3 ] ) ); 
%
function y = gaussian( A , b )
%
%
Tol = 10^-5 ;
[ m , n ] = size( A ) ;
x = zeros( n , 1 ) ;
y = zeros( n , 1 ) ;
t = zeros( n , 1 ) ;
if m ~= n
    disp ( ' Not a square matrix. Try again' )
else
    if abs( det(A) ) <= Tol ;
        disp( ' A is singular or close to be singular. I recommend you to try a different A' )
    else 
        L = eye( m ) ;
        sigma = transpose( 1 : n ) ;
        for r = 1 : m-1
            M = full_pivoting( A , b , r ) ; 
            g = permutations( A , sigma , r ) ;
            if M( r , r ) == 0 
               error( 'Pivot is 0' ) ; 
               return ; 
            end
            for k = r + 1 : m
                L( k , r ) = M( k , r )/M( r , r ) ;
                for j = r + 1 : n + 1
                    M( k , j ) = M( k , j ) - L( k , r )* M( r , j ) ;
                end
                for j = 1 : r
                    M( k , j ) = 0 ;
                end
            end
            A = M( : , 1 : end - 1 ) ;
            b = M( : , end ) ;
            sigma = g ;
        end
        %M
         x( n ) = b( n )/M( n , n ) ;
         for d = n - 1 : -1 : 1
             for s = d : n-1
             t( s , 1 ) = M( d , s + 1 )/M( d , d ) * x( s + 1 ) ;  
             end
             x( d ) = b( d )/M( d , d ) - sum( t ) ;
         end
         for a = 1 : n
          y( a ) = x( g(a ) ) ; 
         end
    end
   
end
