% B R I E F  C O D E  D E S C R I P T I O N :
%
% Given the system Ax = b. Permutations will give the permutation vector of
%
%the elements of x due to column operations done on the matrix A
%
function g = permutations( A , sigma , k )
%
% I N P U T : A = Matrix of dimension m x n, sigma = vector of dimension n x 1
%
% which contains the original positions of the elemnts of the vector 
%
% x = [x1 x2 x3]', i. e. sigma = [1 3 2]' says that x(1) = x1, x(2) = x3
%
% and x(3) = x2 . The elemnts of the vector sigma can take values from 1 to n.
%
%k = scalar from 1 to minimum( m , n ) .
%
% O U T P U T : g = permutation of the elements of the vector x after
%
% column operations on the matrix A.
%
% E X A M P L E : Type in the command window of Matlab: 
%
%   permutations( [ 1 2 3 ; 5 0 2 ; 1 7 0 ] , transpose( [ 1 3 2 ] ), 2 ) ;
%
[ m , n ] = size( A ) ;
%
%-------------- Looking for the pivot ------------------------
i_max = k ;
j_max = k ;
%
for i = k : m
    for j = k : n
        if abs( A( i , j ) ) > abs( A( i_max , j_max ) )
            i_max = i ;
            j_max = j ;
        end
    end
end
% Finding the permutation of the elements of x when the pivot is sended to the position (k,k) --
%
% Interchanging rows 

sigma_k = sigma( k ) ;
sigma_max = sigma( j_max ) ;
sigma( k ) = sigma_max ;
sigma( j_max ) = sigma_k ;
g = sigma ;

