% Testing script for fpGelim.m

numOfMatrices = 4;    % how many random A's to generate
numOfUseOfAMatrix = 5;  % how many times is each A to be used

for i1 = 1:numOfMatrices

    dimMatrix = randi(9) + 1;   % random dimension of the square A matrix
    fprintf('Dimension = %d\n',dimMatrix);
    
    A = rand(dimMatrix)
    
    for i2 = 1:numOfUseOfAMatrix

        fprintf('\n---------\n');
        
        xActual = rand(dimMatrix,1);
        b = A*xActual
        
        [xCalc, singular] = fpGelim(A,b);
        
        if (singular == 0)
        
            dist = norm(xActual - xCalc);
            fprintf('Norm of difference between xActual and xCalc is\n');
            fprintf('(0.123456789012345678)\n');
            fprintf(' %.18f\n', dist);
            
        else
            
            pause
            
        end

    end
    
    fprintf('\n---------------------------------------------------------\n');
    fprintf('---------------------------------------------------------\n\n');
    
end

