%This computes the prime function using an infinite product

%It needs three subsidiary M-files:
%        SKProd.m
%        generatemaps.m
%        constructmaps.m

clear all

global THETA M

%Set circular domain data:
qv=[0.1 0.1];
dv=[0.5 0.5*i];

M=numel(qv);

for k=1:M;
THETA{k}=[(qv(k)^2-abs(dv(k))^2)/qv(k) dv(k)/qv(k);-conj(dv(k))/qv(k) 1/qv(k)];
THETA{2*M-(k-1)}=inv(THETA{k});
end;

%now decide on the level of truncation
level=4;

%construct maps up to this level
maps=constructmaps(level);

