function p=constructmaps(level)

%This function constructs the maps up to a given level

global THETA M

%first install level 1 maps
for k=1:M
    TT=THETA{k};TT=TT.';
    p(:,k)=TT(:);
end;

%now install all remaining levels one by one
for k=2:level
    A=generatemaps(M,k);
    i=find(A < 0);A(i)=A(i)+(2*M+1);   %correct the indices for inverse maps
    [r,c]=size(A);
    for kr=1:r
        map=eye(2,2);                  %reset composition to
        for kc=1:c
        map=map*THETA{A(kr,kc)};       %compose all maps at this level
        end;
        map=map.';
        p=[p map(:)];                  %add elements of the storage matrix
    end;
end;

%The output contains a 4-by-X matrix with each column of form [a;b;c;d]