function p=generatemaps(M,lev)

%M = number of holes
%lev = level of maps

A=[-M:1:-1 1:1:M];
A=A.';

%number of generators
g=2*M;

for k=1:lev;
    
col=A(:,ones(1,g^(lev-k)));
col=col.';col=col(:);
col=col(:,ones(1,g^(k-1)));
col=col(:);
column{k}=col;

end;

%combine columns to give ALL maps at this level
MAT=column{1};
for k=2:lev;
    MAT=[MAT column{k}];
end;

%now get rid of inverses
MAT2=circshift(MAT,[0 1]); %shift columns to right by 1
MAT3=MAT+MAT2;             %add up columns
MAT4=MAT3(:,2:end);        %ignore first column
MAT5=min(abs(MAT4),[],2);  %find minimum of absolute value in each row
rowindex=find(MAT5 ~= 0);  %include only those that don't give 0
MAT6=MAT(rowindex,:);      %these are maps which don't reduce to lower level map

%Now eliminate inverses
list(1,:)=MAT6(1,:);
count=1;
for k=2:numel(rowindex)
    flag=0;
    inv=-fliplr(MAT6(k,:));
    for k2=1:k-1;          %check if inverse is in list
        if MAT6(k2,:)-inv == 0
            flag=1;       %if so, do not include it
        end;
    end;
    if flag == 0           %include map if no inverse is in list so far
        count=count+1;
        list(count,:)=MAT6(k,:);
    end;
end;

p=list;


